/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting;


/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface CallbackStoreMBean extends SerializableStore
{
   /**
    * Gets the file path for the directory where the objects will be stored.
    *
    * @return
    */
   String getStoreFilePath();

   /**
    * Sets teh file path for the directory where the objects will be stored.
    *
    * @param filePath
    */
   void setStoreFilePath(String filePath);

   /**
    * Gets the file suffix for each of the files that objects will be persisted to.
    *
    * @return
    */
   String getStoreFileSuffix();

   /**
    * Sets the file suffix for each of the files that objects will be persisted to.
    *
    * @param fileSuffix
    */
   void setStoreFileSuffix(String fileSuffix);

}
