/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

/**
 * This class implements <tt>javax.jms.TopicSubscriber</tt>.
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SpyTopicSubscriber extends SpyMessageConsumer implements TopicSubscriber
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
	 * Create a new SpyTopicSubscriber
	 * 
	 * @param session the session
	 * @param topic the topic
	 * @param noLocal true for no local, false otherwise
	 * @param selector the selector
	 * @throws InvalidSelectorException for an invalid selector
	 */
   SpyTopicSubscriber(SpySession session, SpyTopic topic, boolean noLocal, String selector)
         throws InvalidSelectorException
   {
      super(session, false, topic, selector, noLocal);
   }

   // Public --------------------------------------------------------

   // TopicSubscriber implementation --------------------------------

   public Topic getTopic() throws JMSException
   {
      if (closed)
         throw new IllegalStateException("The MessageConsumer is closed");
      return (Topic) subscription.destination;
   }

   public boolean getNoLocal() throws JMSException
   {
      if (closed)
         throw new IllegalStateException("The MessageConsumer is closed");
      return subscription.noLocal;
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}