/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

/**
 * FileChannel utils.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class FileChannelUtils
{
   public MappedByteBuffer getMappedByte(String fileName) throws IOException
   {
      FileChannel fileChannel = new FileInputStream(fileName).getChannel();
      int fileSize = (int) fileChannel.size();
      MappedByteBuffer mappedfile =
         fileChannel.map(FileChannel.MapMode.READ_ONLY, 0, fileSize);
      mappedfile.load();
      return mappedfile;
   }
}
