/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package org.jboss.media.format.image.iio;

import java.io.InputStream;

import javax.emb.MediaException;
import javax.emb.MediaHeader;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;

/**
 * PNG <code>MediaFormat</code> based on the Java Image I/O API.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class PNGMediaFormat extends IIOMediaFormat
{
   // FIXME
   private static final long serialVersionUID = 0L;

   /**
    * Constructor.
    * 
    * @param imageReader
    */
   public PNGMediaFormat(ImageReader imageReader)
   {
      super(imageReader);
   }

   /**
    * @see javax.emb.MediaFormat#extractHeader(javax.emb.Media)
    */
   public MediaHeader extractHeader(InputStream content) throws MediaException
   {
      IIOMetadata imageMetadata = extractImageMetadata(content);
      return new PNGMediaHeader(imageMetadata);
   }
}