/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.format.audio.oggvorbis;

import java.io.InputStream;
import java.net.URL;

import javax.emb.Media;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MediaHeader;
import javax.emb.MediaSegment;

/**
 * Represents the Ogg Vorbis format.
 * 
 * <p>More info at <a href="http://www.vorbis.com/">www.vorbis.com</a> and
 * <a href="http://www.xiph.org/ogg/vorbis/">www.xiph.org/ogg/vorbis</a>.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class OggVorbisFormat implements MediaFormat
{
   /**
    * @see javax.emb.MediaFormat#assembleContent(java.net.URL, javax.emb.MediaSegment[])
    */
   public byte[] assembleContent(
      URL mediaLocation,
      MediaSegment[] mediaSegments)
      throws MediaException
   {
      return null;
   }

   /**
    * @see javax.emb.MediaFormat#disassembleContent(java.net.URL, byte[])
    */
   public MediaSegment[] disassembleContent(
      URL mediaLocation,
      byte[] mediaContent)
      throws MediaException
   {
      return null;
   }

   /**
    * @see javax.emb.MediaFormat#extractHeader(java.io.InputStream)
    */
   public MediaHeader extractHeader(InputStream content) throws MediaException
   {
      if (content == null)
      {
         throw new NullPointerException();
      }

      return new OggVorbisHeader(content);
   }

   /**
    * @see javax.emb.MediaFormat#extractProxy(java.io.InputStream)
    */
   public Media extractProxy(InputStream content) throws MediaException
   {
      // TODO: Create a generic proxy
      return null;
   }

   /**
    * @see javax.emb.MediaFormat#getDefaultMimeType()
    */
   public String getDefaultMimeType()
   {
      return "application/ogg";
   }

   /**
    * @see javax.emb.MediaFormat#isEmbedded()
    */
   public boolean isEmbedded()
   {
      return false;
   }

   /**
    * @see javax.emb.MediaFormat#isStreamingDesirable()
    */
   public boolean isStreamingDesirable()
   {
      return true;
   }
}