/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.media.exampleplugins;

import javax.media.Buffer;

import org.jboss.logging.Logger;
import org.jboss.media.engine.MediaPlugin;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 */
public class UselessInfoPlugin extends MediaPlugin
{

   private static Logger log = Logger.getLogger(UselessInfoPlugin.class);
   /* (non-Javadoc)
    * @see org.jboss.media.engine.MediaPlugin#process(javax.media.Buffer)
    */
   public int process(Object out)
   {
      // For demo, we'll just print out the frame #, time &
      // data length.
      Buffer output = (Buffer)out;
      long t = (long) (output.getTimeStamp() / 10000000f);

      log.info(
         "Post: frame #: "
            + output.getSequenceNumber()
            + ", time: "
            + ((float) t) / 100f
            + ", len: "
            + output.getLength());
      return 0;
   }

}
