/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.media.exampleplugins;

import javax.media.Buffer;

import org.jboss.media.engine.MediaPlugin;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 */
public class ColorToGrayScale extends MediaPlugin
{

   /** 
    * @see org.jboss.media.engine.MediaPlugin#process(javax.media.Buffer)
    * Convert from color to grayscale
    */
   public int process(Object out)
   {
      Buffer output = (Buffer)out;
      byte[] data = (byte[]) output.getData();

      float blue = 0.299f;
      float green = 0.587f;
      float red = 0.114f;

      for (int i = 0; i < data.length; i += 3)
      {
         //convert from color to black and white

         int grey =
            java.lang.Math.round(
               (data[i] * blue + data[i + 1] * green + data[i + 2] * red))
               & 0xff;

         data[i] = (byte) grey;
         data[i + 1] = (byte) grey;
         data[i + 2] = (byte) grey;
      }

      return 0;
   }

}
