package org.jboss.media.entity.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import javax.ejb.FinderException;
import javax.emb.IllegalOptionException;
import javax.emb.MediaException;

import org.jboss.media.entity.MetaDataEntityBean;

public class JBossMediaQueryLanguage implements MediaQueryLanguage
{
   private static final String NAME = "JBossMediaQueryLanguage";

   private static final Map OPTIONS =
      Collections.unmodifiableMap(Collections.EMPTY_MAP);

   public JBossMediaQueryLanguage()
   {
   }

   public String getName() throws MediaException
   {
      return NAME;
   }

   public Map getOptions() throws MediaException
   {
      return Collections.EMPTY_MAP;
   }

   public void setOptions(Map options) throws MediaException
   {
      throw new IllegalOptionException("You can't set options for this query language");
   }

   public Collection query(MetaDataEntityBean metaDataEntity, String query)
      throws FinderException, MediaException
   {
      return metaDataEntity.ejbSelectByPartialXML(query);
   }
}