/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */


package org.jboss.media.engine;

import java.util.HashMap;
import java.util.Iterator;

import org.jboss.system.ServiceMBeanSupport;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 * @jmx.mbean extends="org.jboss.system.ServiceMBean"
 * @jmx.mbean description="The media engine transcoder registry"
 */
public class MediaTranscoderRegistry
   extends ServiceMBeanSupport
      implements MediaTranscoderRegistryMBean
{

	private HashMap m_transcoders = new HashMap();
   
   /**
    * @jmx.managed-operation description="add a transcoder"
    */
   public void addTranscoder(String name , MediaTranscoder object)
   {
      m_transcoders.put(name,object);
   }
   
   /**
    * @jmx.managed-operation description="remove a transcoder"
    */
   public void removeTranscoder(String name)
   {
      m_transcoders.remove(name);
   }
   
   /**
    * @jmx.managed-operation description="get the list of transcoder"
    */
   public Iterator getTranscoderNames()
   {
      return ((HashMap)m_transcoders.clone()).keySet().iterator();
   }
   
   
   /**
    * @jmx.managed-operation description="acquire a transcoder"
    */
   public MediaTranscoder getTranscoder(String name)
   {
      return (MediaTranscoder)m_transcoders.get(name);
   }

}
