/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.engine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;


/**
 * The plugin media graph. To be linked with the correct media
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 */
public class MediaPluginGraph
{
   Map graph = new HashMap();
   
	/**
	 * Method addPlugin.
	 * @param plugin The plugin object
	 * @param pos The position in the graph
	 * @throws MediaPluginGraphException
	 */
   public void addPlugin ( MediaPlugin plugin , int pos) 
      throws MediaPluginGraphException
   {
      Integer position = new Integer ( pos ) ;
      if(graph.containsKey(position)) 
         throw new MediaPluginGraphException("A plugin already exists in position" + position);
         
      graph.put(position, plugin);
   }
   
   
   
	/**
	 * Method getPluginVector.
	 * @return Vector of a series of plugins
	 */
   public Vector getPluginVector()
   {
      Vector plugins = new Vector();
      
      int[] keys = new int[graph.keySet().size()];
      
      //get the keys
      Iterator it = graph.keySet().iterator();
      for( int i = 0 ; i < graph.keySet().size(); i++ ) 
      {
         keys[i] = ((Integer)it.next()).intValue();
      }
      
      // sort them 
      Arrays.sort(keys); 
     
      // add them to the vector
      for ( int i = 0 ; i < keys.length ; i++ ) 
      {
         Object mediaPlugin = graph.get(new Integer(i));
         plugins.add(mediaPlugin);
      }
      
      return plugins; 
   } 
}
