/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown if there is a problem altering a media entity
 * previous version association.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class VersionChainIntegrityException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public VersionChainIntegrityException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public VersionChainIntegrityException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public VersionChainIntegrityException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public VersionChainIntegrityException(Throwable cause)
   {
      super(cause);
   }
}