/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

import javax.ejb.RemoveException;

/**
 * This exception is thrown if a media entity EJB cannot be removed because it
 * has associations to a previous version in the version chain. Removing a
 * media entity EJB while it has a previous version would violate referential
 * integrity and is therefore forbidden.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class PredecessorAssociationExistsException extends RemoveException
{
   /**
    * @see javax.ejb.RemoveException()
    */
   public PredecessorAssociationExistsException()
   {
      super();
   }

   /**
    * @see javax.ejb.RemoveException(String)
    */
   public PredecessorAssociationExistsException(String message)
   {
      super(message);
   }
}