/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown during <code>MetaDataEntityLocal.setXML()</code>
 * whenever the XML metadata validation fails.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class MetaDataValidationException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public MetaDataValidationException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public MetaDataValidationException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public MetaDataValidationException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public MetaDataValidationException(Throwable cause)
   {
      super(cause);
   }
}