/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is root to most application specific exceptions thrown by
 * Enterprise Media Beans components. The idea is to abstract over the specific
 * causes of exceptional behavior as the causes of such behavior can differ a
 * lot between different Enterprise Media Beans implementations. As this would
 * prevent applications to be written in an implementation independent way,
 * these causes have to be mapped to a unified exception model.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class MediaException extends Exception
{
   /**
    * @see java.lang.Exception()
    */
   public MediaException()
   {
      super();
   }

   /**
    * @see java.lang.Exception(String)
    */
   public MediaException(String message)
   {
      super(message);
   }

   /**
    * @see java.lang.Exception(String, Throwable)
    */
   public MediaException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see java.lang.Exception(Throwable)
    */
   public MediaException(Throwable cause)
   {
      super(cause);
   }
}