/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception extends javax.emb.MediaException and is thrown by Media
 * entity listener EJBs in order to issue a veto against a media entity EJB
 * modification.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class ListenerVetoException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public ListenerVetoException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public ListenerVetoException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public ListenerVetoException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public ListenerVetoException(Throwable cause)
   {
      super(cause);
   }
}