/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever media content does not match the syntax
 * defined for its media format.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class FormatSyntaxException extends MediaFormatException
{
   /**
    * @see javax.emb.MediaFormatException()
    */
   public FormatSyntaxException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaFormatException(String)
    */
   public FormatSyntaxException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaFormatException(String, Throwable)
    */
   public FormatSyntaxException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaFormatException(Throwable)
    */
   public FormatSyntaxException(Throwable cause)
   {
      super(cause);
   }
}