/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever a media format cannot be determined.
 * Usually the media format registry throws this exception.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class FormatNotFoundException extends MediaFormatException
{
   /**
    * @see javax.emb.MediaFormatException()
    */
   public FormatNotFoundException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaFormatException(String)
    */
   public FormatNotFoundException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaFormatException(String, Throwable)
    */
   public FormatNotFoundException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaFormatException(Throwable)
    */
   public FormatNotFoundException(Throwable cause)
   {
      super(cause);
   }
}