/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.StatefulSessionBeanStats;

/**
 * The JSR77.6.11 EJBStats implementation
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class StatefulSessionBeanStatsImpl extends EJBStatsImpl
        implements StatefulSessionBeanStats
{
   // Constants -----------------------------------------------------
   
   /** @since 4.0.2 */
   private static final long serialVersionUID = -6172970386064136821L;

   // Private Data --------------------------------------------------
   
   private RangeStatisticImpl methodReadyCount;
   private RangeStatisticImpl passiveCount;

   // Constructors --------------------------------------------------
      
   public StatefulSessionBeanStatsImpl()
   {
      methodReadyCount = new RangeStatisticImpl("MethodReadyCount", "1",
              "The count of beans in the method-ready state");
      passiveCount = new RangeStatisticImpl("PassiveCount", "1",
              "The count of beans in the passivated state");
      addStatistic("MethodReadyCount", methodReadyCount);
      addStatistic("PassiveCount", passiveCount);
   }

// Begin javax.management.j2ee.statistics.StatefulSessionBeanStats interface methods

   public RangeStatistic getMethodReadyCount()
   {
      return methodReadyCount;
   }

   public RangeStatistic getPassiveCount()
   {
      return passiveCount;
   }

// End javax.management.j2ee.statistics.StatefulSessionBeanStats interface methods
}
