/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.management.j2ee.statistics;

import org.jboss.management.j2ee.StatisticsConstants;

import javax.management.j2ee.statistics.ServletStats;
import javax.management.j2ee.statistics.TimeStatistic;

/**
 * The implementation of the JSR77 ServletStats model
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class ServletStatsImpl extends StatsBase
        implements ServletStats
{
   // Constants -----------------------------------------------------
   
   /** @since 4.0.2 */
   private static final long serialVersionUID = -4174188800489609026L;
   
   // Constructors --------------------------------------------------
      
   public ServletStatsImpl()
   {
      this(new TimeStatisticImpl("ServiceTime", StatisticsConstants.MILLISECOND,
              "The execution time of the servlet"));
   }

   public ServletStatsImpl(TimeStatistic serviceTime)
   {
      addStatistic("ServiceTime", serviceTime);
   }

   public TimeStatistic getServiceTime()
   {
      return (TimeStatistic) getStatistic("ServiceTime");
   }
}
