/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee;

import org.jboss.logging.Logger;
import org.jboss.management.j2ee.statistics.RangeStatisticImpl;
import org.jboss.management.j2ee.statistics.StatelessSessionBeanStatsImpl;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;

/**
 * The JBoss JSR-77.3.15 implementation of the StatelessSessionBean model
 *
 * @author <a href="mailto:andreas@jboss.org">Andreas Schaefer</a>.
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 * @jmx:mbean extends="org.jboss.management.j2ee.SessionBeanMBean"
 */
public class StatelessSessionBean
        extends SessionBean
        implements StatelessSessionBeanMBean
{

   // Attributes ----------------------------------------------------
   private static Logger log = Logger.getLogger(StatelessSessionBean.class);
   private StatelessSessionBeanStatsImpl stats;

   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
    * Create a StatelessSessionBean model
    *
    * @param name             the ejb name, currently the JNDI name
    * @param ejbModuleName    the JSR-77 EJBModule name for this bean
    * @param ejbContainerName the JMX name of the JBoss ejb container MBean
    * @throws MalformedObjectNameException
    * @throws InvalidParentException
    */
   public StatelessSessionBean(String name, ObjectName ejbModuleName,
                               ObjectName ejbContainerName)
           throws MalformedObjectNameException,
           InvalidParentException
   {
      super(J2EETypeConstants.StatelessSessionBean, name, ejbModuleName, ejbContainerName);
      stats = new StatelessSessionBeanStatsImpl();
   }

   // Begin StatisticsProvider interface methods
   public Stats getstats()
   {
      try
      {
         updateCommonStats(stats);

         ObjectName poolName = getContainerPoolName();
         RangeStatisticImpl readyCount = (RangeStatisticImpl) stats.getMethodReadyCount();
         Integer poolSize = (Integer) server.getAttribute(poolName, "CurrentSize");
         readyCount.set(poolSize.longValue());
      }
      catch (Exception e)
      {
         log.debug("Failed to retrieve stats", e);
      }
      return stats;
   }

   public void resetStats()
   {
      stats.reset();
   }
   // End StatisticsProvider interface methods

   // Object overrides ---------------------------------------------------

   public String toString()
   {
      return "StatelessSessionBean { " + super.toString() + " } []";
   }

}
