/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:Stats.java,v 1.0, 2005-06-24 19:17:01Z, Robert Worsnop$


/**
 * The Stats model and its submodels specify performance data attributes for each of the specific managed object types.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface Stats
{
   /**
    * Get a Statistic by name.
    */
   public Statistic getStatistic(String statisticName);

   /**
    * Returns an array of Strings which are the names of the attributes from the specific Stats submodel that this object supports.
    * Attributes named in the list must correspond to attributes that will return a Statistic object of the appropriate type
    * which contains valid performance data. The return value of attributes in the Stats submodel that are not included in
    * the statisticNames list must be null. For each name in the statisticNames list there must be one Statistic with the
    * same name in the statistics list.
    */
   public String[] getStatisticNames();

   /**
    * Returns an array containing all of the Statistic objects supported by this Stats object.
    */
   public Statistic[] getStatistics();
}

