/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:RangeStatistic.java,v 1.0, 2005-06-24 19:14:35Z, Robert Worsnop$


/**
 * Specifies standard measurements of the lowest and highest values an attribute has held as well as its current value.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface RangeStatistic extends Statistic
{
   /**
    * The highest value this attribute has held since the beginning of the measurement.
    */
   public long getHighWaterMark();

   /**
    * The lowest value this attribute has held since the beginning of the measurement.
    */
   public long getLowWaterMark();

   /**
    * The current value of this attribute.
    */
   public long getCurrent();
}

