/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JMSSessionStats.java,v 1.0, 2005-06-24 19:10:05Z, Robert Worsnop$


/**
 * Specifies the statistics provided by a JMS session.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JMSSessionStats extends Stats
{
   /**
    * Returns an array of JMSProducerStats that provide statistics about the message producers associated with the referencing JMS session statistics.
    */
   public JMSProducerStats[] getProducers();

   /**
    * Returns an array of JMSConsumerStats that provide statistics about the message consumers associated with the referencing JMS session statistics.
    */
   public JMSConsumerStats[] getConsumers();

   /**
    * Number of messages exchanged.
    */
   public CountStatistic getMessageCount();

   /**
    * Number of pending messages.
    */
   public CountStatistic getPendingMessageCount();

   /**
    * Number of expired messages.
    */
   public CountStatistic getExpiredMessageCount();

   /**
    * Time spent by a message before being delivered.
    */
   public TimeStatistic getMessageWaitTime();


   /**
    * Number of durable subscriptions.
    */
   public CountStatistic getDurableSubscriptionCount();
}

