/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JMSEndpointStats.java,v 1.0, 2005-06-24 19:10:00Z, Robert Worsnop$


/**
 * Specifies the statistics provided by a JMS message producer or a JMS message consumer.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JMSEndpointStats extends Stats
{
   /**
    * Number of messages sent or received.
    */
   public CountStatistic getMessageCount();

   /**
    * Number of pending messages.
    */
   public CountStatistic getPendingMessageCount();

   /**
    * Number of messages that expired before delivery.
    */
   public CountStatistic getExpiredMessageCount();


   /**
    * Time spent by a message before being delivered.
    */
   public TimeStatistic getMessageWaitTime();
}

