/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JDBCConnectionStats.java,v 1.0, 2005-06-24 19:09:23Z, Robert Worsnop$


/**
 * Specifies the statistics provided by all (pooled and non-pooled) JDBC connections.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JDBCConnectionStats extends Stats
{
   /**
    * Identifies the JDBC driver for the corresponding JDBCConnection.
    */
   public String getJdbcDataSource();

   /**
    * Time spent waiting for a connection to be available.
    */
   public TimeStatistic getWaitTime();

   /**
    * Time spent using a connection.
    */
   public TimeStatistic getUseTime();

}

