/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JCAStats.java,v 1.0, 2005-06-24 19:09:19Z, Robert Worsnop$

import javax.management.*;
import javax.management.j2ee.Management;
import javax.ejb.EJBObject;
import javax.ejb.EJBHome;
import javax.ejb.CreateException;
import java.rmi.RemoteException;
import java.util.Set;

/**
 * Specifies statistics provided by a JCA resource
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JCAStats extends Stats
{
   /**
    * Returns an array of JCAConnectionStats that provide statistics about the non-pooled connections associated with the referencing JCA resource statistics
    */
   public JCAConnectionStats[] getConnections();

   /**
    * Returns an array of JCAConnectionPool Stats that provide statistics about the connection pools associated with the referencing JCA resource statistics
    */
   public JCAConnectionPoolStats[] getConnectionPools();

}

