/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package test.implementation.util.support;

import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.MBeanParameterInfo;

/**
 * Overrides and exposes java.lang.Object methods in the management
 * interface.
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision:1$
 */
public class ResourceOverride
{
   
   // Attributes ----------------------------------------------------
   
   private String state = null;
   
   
   // Constructors --------------------------------------------------
   public ResourceOverride(String state)
   {
      this.state = state;
   }
   
   public ResourceOverride() {}
   
   
   // Public --------------------------------------------------------
   
   public ModelMBeanInfo getMBeanInfo() 
   {
      ModelMBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[] 
      {
         new ModelMBeanAttributeInfo(
               "AttributeName", "java.lang.String", "description",
               false, true, false
         ),
         new ModelMBeanAttributeInfo(
               "AttributeName2", "java.lang.String", "description",
               true, true, false
         )
      };
      
      ModelMBeanOperationInfo[] operations = new ModelMBeanOperationInfo[]
      {
         new ModelMBeanOperationInfo(
               "doOperation", "description", null, "java.lang.Object", 1
         ),
         
         new ModelMBeanOperationInfo(
               "toString", "toString override", null, "java.lang.String", 1
         ),
         
         new ModelMBeanOperationInfo(
               "equals", "equals override",
               new MBeanParameterInfo[] 
               {
                  new MBeanParameterInfo("object", "java.lang.Object", "object to compare to")
               },
               "boolean", 1
         ),
         
         new ModelMBeanOperationInfo(
               "hashCode", "hashCode override in resource", null, Integer.TYPE.getName(), 1
         )
      };
      
      ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(
            "test.implementation.util.support.Resource", "description",
            attributes, null, operations, null
      );
      
      return info;
   }


   public Object doOperation() 
   {
      return "tamppi";
   }

   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      return "Resource";
   }
   
   public boolean equals(Object o)
   {
      return true;
   }
   
   public int hashCode()
   {
      return 10;
   }
}
      



