/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.security;

import java.security.PermissionCollection;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.MBeanServerPermission;
import javax.management.relation.RelationService;

import junit.framework.TestCase;
import test.compliance.server.support.Broadcaster;
import test.compliance.server.support.Test;

/** Tests of the javax.management.MBeanServerPermission
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class MBeanServerPermissionTestCase
  extends TestCase
{
   public MBeanServerPermissionTestCase(String s)
   {
      super(s);
   }

   public void testMBeanServerPermission()
   {
      MBeanServerPermission p0 = new MBeanServerPermission("newMBeanServer");
      MBeanServerPermission p1 = new MBeanServerPermission("createMBeanServer");
      assertTrue("createMBeanServer implies newMBeanServer", p1.implies(p0));
      assertTrue("createMBeanServer implies newMBeanServer", p0.implies(p1));

      PermissionCollection pc = p0.newPermissionCollection();
      pc.add(p0);
      assertTrue("PC(newMBeanServer) implies createMBeanServer", pc.implies(p1));
   }
}
