/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.notification;

import javax.management.JMException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

/**
 * A notification listener registration factory.
 * 
 * @see org.jboss.mx.notification.ListenerRegistry
 * @see org.jboss.mx.notification.ListenerRegistration
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
public interface ListenerRegistrationFactory
{
   /**
    * Create a listener registration
    *
    * @param listener the notification listener
    * @param filter the notification filter
    * @param handback the handback object
    * @return the listener registration
    * @exception JMException for an error
    */
   ListenerRegistration create(NotificationListener listener,
                               NotificationFilter filter,
                               Object handback)
      throws JMException;
}
