/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.mx.modelmbean;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.RequiredModelMBean;

import org.jboss.mx.server.RawDynamicInvoker;

/** An invoker that handles the 'ops' that are part of the RequiredModelMBean
 * that must be handled at that level rather than its delegate.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revison:$
 */
public class RequiredModelMBeanInvoker extends RawDynamicInvoker
{
   RequiredModelMBean mbean;

   public RequiredModelMBeanInvoker(DynamicMBean resource)
   {
      super(resource);
      mbean = (RequiredModelMBean) resource;
   }

   public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException
   {
      try
      {
         return super.getAttribute(name);
      }
      catch (ReflectionException e)
      {
         // Another inconsistency
         Exception ex = e.getTargetException();
         if ((ex instanceof ClassNotFoundException) == false &&
             (ex instanceof NoSuchMethodException) == false)
         {
            log.debug("Rewrapping reflection exception: ", e);
            throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
         }
         else
            throw e;
      }
   }

   public void setAttribute(Attribute attribute)
      throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
   {
      // Another inconsistency
      if (attribute == null)
         throw new RuntimeOperationsException(new IllegalArgumentException("Null attribute"));
      try
      {
         super.setAttribute(attribute);
      }
      catch (ReflectionException e)
      {
         // Another inconsistency
         Exception ex = e.getTargetException();
         if ((ex instanceof ClassNotFoundException) == false &&
             (ex instanceof NoSuchMethodException) == false)
         {
            log.debug("Rewrapping reflection exception: ", e);
            throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
         }
         else
            throw e;
      }
   }

   public AttributeList getAttributes(String[] attributes)
   {
      if (attributes == null)
         throw new RuntimeOperationsException(new IllegalArgumentException("Null attributes"));
      return super.getAttributes(attributes);
   }

   public AttributeList setAttributes(AttributeList attributes)
   {
      if (attributes == null)
         throw new RuntimeOperationsException(new IllegalArgumentException("Null attributes"));
      return super.setAttributes(attributes);
   }

   public Object invoke(String name, Object[] args, String[] signature) throws
      MBeanException, ReflectionException
   {
      Object value;

      if (name == null)
         throw new RuntimeOperationsException(new IllegalArgumentException("Null operation"));
      else if( name.equals("getNotificationInfo") )
         value = mbean.getNotificationInfo();
      else
      {
         try
         {
            value = super.invoke(name, args, signature);
         }
         catch (RuntimeMBeanException e)
         {
            // For some reason (not mentioned in the spec) these have to
            // be wrapped in MBeanExceptions for RMM
            throw new MBeanException(e.getTargetException(), e.getMessage());
         }
         catch (ReflectionException e)
         {
            // Another inconsistency
            Exception ex = e.getTargetException();
            if ((ex instanceof ClassNotFoundException) == false &&
                (ex instanceof NoSuchMethodException) == false)
            {
               log.debug("Rewrapping reflection exception: ", e);
               throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
            }
            else
               throw e;
         }
      }
      return value;
   }
}
