/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.metadata;

// $Id:XMBeanEntityResolver.java,v 1.0, 2005-06-24 19:19:33Z, Robert Worsnop$

import org.jboss.logging.Logger;
import org.jboss.mx.service.ServiceConstants;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

import java.io.InputStream;

/**
 * XMBeanEntityResolver.java
 * <p/>
 * Created: Sun Sep  1 20:54:10 2002
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @author <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>.
 * @version $Revision:1$
 */
public class XMBeanEntityResolver
        implements EntityResolver, ServiceConstants
{
   private static final Logger log = Logger.getLogger(XMBeanEntityResolver.class);

   public InputSource resolveEntity(String publicId, String systemId)
   {
      try
      {
         if (publicId.equals(PUBLIC_JBOSSMX_XMBEAN_DTD_1_0))
         {
            InputStream dtdStream = getClass().getResourceAsStream("/dtd/" + JBOSSMX_XMBEAN_DTD_1_0);
            return new InputSource(dtdStream);

         }
         else if (publicId.equals(PUBLIC_JBOSSMX_XMBEAN_DTD_1_1))
         {
            InputStream dtdStream = getClass().getResourceAsStream("/dtd/" + JBOSSMX_XMBEAN_DTD_1_1);
            return new InputSource(dtdStream);
         }
         else if (publicId.equals(PUBLIC_JBOSSMX_XMBEAN_DTD_1_2))
         {
            InputStream dtdStream = getClass().getResourceAsStream("/dtd/" + JBOSSMX_XMBEAN_DTD_1_2);
            return new InputSource(dtdStream);
         }         
         else
         {
            log.warn ("Cannot resolve entity: " + publicId);
         }
      }
      catch (Exception ignore)
      {
         log.error ("Cannot load local entity resource for: " + publicId);
      }
      return null;
   }
}
