/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.interceptor;

import javax.management.MBeanInfo;

import org.jboss.mx.metadata.MBeanInfoConversion;
import org.jboss.mx.server.Invocation;

/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision:1$
 */   
public class StandardMBeanInfoInterceptor extends AbstractInterceptor
{
   // cached info
   MBeanInfo standardInfo = null;
   
   public StandardMBeanInfoInterceptor()
   {
      // FIXME: xxx
      super("Standard MBeanInfo Interceptor for XXX");
   }
   
   public Object invoke(Invocation invocation) throws Throwable
   {

      MBeanInfo info = null;
      
      try
      {
         info = (MBeanInfo)super.invoke(invocation);
      }
      finally
      {
         if (standardInfo == null)
         {
            standardInfo = MBeanInfoConversion.stripAttributeOperations(MBeanInfoConversion.toModelMBeanInfo(info), false);
         }
      }
      return standardInfo;
   }
}

