/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.loading;

import java.net.URL;
import java.net.MalformedURLException;
import java.util.Map;

/** The MLET tag representation
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
class MLetContent
{
   private URL mletURL;
   private URL codeBase;
   private Map attributes;

   /**
    * 
    * @param url - MLet text file
    * @param attributes 
    */
   public MLetContent(URL url, Map attributes)
   {
      this.mletURL = url;
      this.attributes = attributes;
      String codebase = (String) getParameter("codebase");
      if( codebase != null )
      {
         if( codebase.endsWith("/") == false )
         {
            codebase += "/";
         }
         try
         {
            codeBase = new URL(mletURL, codebase);
         }
         catch (MalformedURLException e)
         {
         }
      }

      if (codeBase == null)
      {
         String file = mletURL.getFile();
         int i = file.lastIndexOf('/');
         if (i > 0 && i < file.length() - 1)
         {
            try
            {
               codeBase = new URL(mletURL, file.substring(0, i + 1));
            }
            catch (MalformedURLException e)
            {
            }
         }
      }
      if (codeBase == null)
         codeBase = mletURL;
   }

   public Map getAttributes()
   {
      return attributes;
   }

   public String getCode()
   {
      String code = (String) getParameter("code");
      return code;
   }

   public URL getCodeBase()
   {
      return codeBase;
   }

   public URL getDocumentBase()
   {
      return mletURL;
   }

   public String getJarFiles()
   {
      String jarFile = (String) getParameter("archives");
      return jarFile;
   }

   public String getName()
   {
      String name = (String) getParameter("name");
      return name;
   }

   public String getSerializedObject()
   {
      String object = (String) getParameter("object");
      return object;
   }

   public String getVersion()
   {
      String version = (String) getParameter("version");
      return version;
   }

   public Object getParameter(String name)
   {
      return attributes.get(name.toLowerCase());
   }
}
