/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import org.jboss.mx.util.QueryExpSupport;

/**
 * A String that is an arguement to a query.
 * 
 * @author  Adrian.Brock@jboss.org
 * @version $Revision:1$
 */
public class StringValueExp
   implements ValueExp
{
   // Constants ---------------------------------------------------
   
   private static final long serialVersionUID = -3256390509806284044L;
   
   // Attributes --------------------------------------------------

   /**
    * The value of the string
    */
   private String val;

   // Static  -----------------------------------------------------

   // Constructors ------------------------------------------------

   /**
    * Construct a string value expression for the null string.
    */
   public StringValueExp()
   {
   }

   /**
    * Construct a string value expression for the passed string
    *
    * @param value the string
    */
   public StringValueExp(String value)
   {
      this.val = value;
   }

   // Public ------------------------------------------------------

   public ValueExp apply(ObjectName name)
      throws BadStringOperationException,
             BadBinaryOpValueExpException,
             BadAttributeValueExpException,
             InvalidApplicationException
   {
      return this;
   }

   /**
    * Get the value of the string.
    *
    * @return the string value
    */
   public String getValue()
   {
      return val;
   }

   public void setMBeanServer(MBeanServer server)
   {
      QueryExpSupport.server.set(server);
   }

   // Object overrides --------------------------------------------

   public String toString()
   {
      return val;
   }

}
