/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * Thrown when a service is not supported.
 *
 * @author <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ServiceNotFoundException
   extends OperationsException
{
   // Constants -----------------------------------------------------

   private static final long serialVersionUID = -3990675661956646827L;

   // Attributes ----------------------------------------------------

   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
    * Construct a new ServiceNotFoundException with no message.
    */
   public ServiceNotFoundException()
   {
      super();
   }

   /**
    * Construct a new ServiceNotFoundException with the given message.
    *
    * @param message the error message.
    */
   public ServiceNotFoundException(String message)
   {
      super(message);
   }
}

