/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * This interface should be implemented by all MBeans that wish their state
 * to be persisted.
 *
 * @author     <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version    $Revision:1$
 */
public interface PersistentMBean
{

   /** 
    * Retrieves the MBean's state from a persistence store.
    *
    * @throws MBeanException  wraps application exceptions from persistence store 
    * @throws InstanceNotFoundException if the MBean's state could not be found
    */
   public void load()
       throws MBeanException,
      RuntimeOperationsException,
      InstanceNotFoundException;

   /**
    * Stores the MBean's state to a persistence store.
    *
    * @throws MBeanException wraps application exceptions from persistence store
    * @throws InstanceNotFoundException if the MBean's state could not be stored
    */
   public void store()
       throws MBeanException,
      RuntimeOperationsException,
      InstanceNotFoundException;

}

