/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

/**
 * A numeric that is an arguement to a query.
 * 
 * @author  Adrian.Brock@jboss.com
 * @version $Revision:1$
 */
class NumericValueExp extends QueryEval implements ValueExp
{
   // Constants ---------------------------------------------------
   
   private static final long serialVersionUID = -4679739485102359104L;
   private static final ObjectStreamField[] serialPersistentFields;

   // Attributes --------------------------------------------------

   private Number val;

   // Static  -----------------------------------------------------

   static
   {
      serialPersistentFields = new ObjectStreamField[]
      {
         new ObjectStreamField("val", Number.class),
      };
   }

   // Constructors ------------------------------------------------

   public NumericValueExp()
   {
      this.val = new Double(0.0);
   }
   
   public NumericValueExp(Number value)
   {
      this.val = value;
   }

   // Public ------------------------------------------------------

   public boolean isInteger()
   {
      return val instanceof Integer || val instanceof Long;
   }

   public double getLongValue()
   {
      return val.longValue();
   }

   public double getDoubleValue()
   {
      return val.doubleValue();
   }

   // ValueExp implementation -------------------------------------

   public ValueExp apply(ObjectName name)
      throws BadStringOperationException,
             BadBinaryOpValueExpException,
             BadAttributeValueExpException,
             InvalidApplicationException
   {
      return this;
   }

   // Object overrides --------------------------------------------

   public String toString()
   {
      return val.toString();
   }

   private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException
   {
      ois.defaultReadObject();
   }
   
   private void writeObject(ObjectOutputStream oos) throws IOException
   {
      oos.defaultWriteObject();
   }
}
