/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import java.util.EventListener;

/**
 * Must be implemented by objects receiving JMX notifications.
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision:1$
 */
public interface NotificationListener extends EventListener
{

   /**
    * Callback method from the broadcaster MBean this listener implementation
    * is registered to.
    *
    * @param   notification   the notification object
    * @param   handback       the handback object given to the broadcaster
    *                         upon listener registration
    */
   public void handleNotification(Notification notification,
                                  Object handback);


}

