/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * This interface must be implemented by all MBeans that emit notifications.
 *
 * This interface should be used in preference to NotificationBroadcaster.
 *
 * @see  javax.management.NotificationBroadcaster
 * @see  javax.management.NotificationFilter
 * @see  javax.management.NotificationListener
 *
 * @author     <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version    $Revision:1$
 */
public interface NotificationEmitter
   extends NotificationBroadcaster
{
   /**
    * Removes a listener from the Emitter.<p>
    *
    * Only the listener, filter, handback triplet is removed
    *
    * @param   listener the listener object to remove
    * @param   filter   the filter registered with the listener
    * @param   handback the handback object associated with the registered listener
    *
    * @throws ListenerNotFoundException if the listener was not found
    */
   public void removeNotificationListener(NotificationListener listener,
                                          NotificationFilter filter,
                                          Object handback)
       throws ListenerNotFoundException;
}
