/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * A Boolean that is an arguement to a query.
 * 
 * @author  Adrian.Brock@jboss.com
 * @version $Revision:1$
 */
class BooleanValueExp extends QueryEval implements ValueExp
{
   // Constants ---------------------------------------------------
   
   private static final long serialVersionUID = 7754922052666594581L;
   
   // Attributes --------------------------------------------------

   private boolean val;

   // Static  -----------------------------------------------------

   // Constructors ------------------------------------------------

   public BooleanValueExp()
   {
      val = false;
   }
   
   public BooleanValueExp(Boolean value)
   {
      this.val = value.booleanValue();
   }

   // Public ------------------------------------------------------

   public boolean getValue()
   {
      return val;
   }

   // ValueExp implementation -------------------------------------

   public ValueExp apply(ObjectName name)
      throws BadStringOperationException,
             BadBinaryOpValueExpException,
             BadAttributeValueExpException,
             InvalidApplicationException
   {
      return this;
   }

   // Object overrides --------------------------------------------

   public String toString()
   {
      return Boolean.toString(val);
   }

}
