/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:ObjectInstanceSer.java,v 1.0, 2005-06-24 19:13:13Z, Robert Worsnop$

package org.jboss.net.jmx.adaptor;

import org.jboss.axis.Constants;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.Serializer;
import org.jboss.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import javax.management.ObjectInstance;
import javax.xml.namespace.QName;
import java.io.IOException;

/**
 * An <code>ObjectInstanceSer</code> is be used to serialize
 * ObjectInstance using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision:1$
 */
public class ObjectInstanceSer implements Serializer
{

   public void serialize(QName name,
                         Attributes attributes,
                         Object value,
                         SerializationContext context)
           throws IOException
   {
      if (!(value instanceof ObjectInstance))
         throw new IOException("Can't serialize a "
                 + value.getClass().getName()
                 + " instance with a ObjectInstance Serializer.");
      context.startElement(name, attributes);

      context.serialize(new QName("", "objectName"),
              null,
              ((ObjectInstance)value).getObjectName());
      context.serialize(new QName("", "className"),
              null,
              ((ObjectInstance)value).getClassName());

      context.endElement();
      return;

   }

   public Element writeSchema(Class aClass, Types types) throws Exception
   {
      return null;
   }

   public String getMechanismType()
   {
      return Constants.AXIS_SAX;
   }

}