/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:MBeanInfoDeser.java,v 1.0, 2005-06-24 19:11:49Z, Robert Worsnop$

package org.jboss.net.jmx.adaptor;

import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.encoding.DeserializerTarget;
import org.jboss.axis.message.SOAPHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.xml.namespace.QName;

/**
 * An <code>MBeanInfoDeser</code> is be used to deserialize
 * MBeanInfo using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision:1$
 */
public class MBeanInfoDeser extends DeserializerImpl
{

   private String className;
   private String description;
   private MBeanAttributeInfo[] attributes;
   private MBeanConstructorInfo[] constructors;
   private MBeanOperationInfo[] operations;
   private MBeanNotificationInfo[] notifications;

   public void onStartElement(String namespace,
                              String localName,
                              String prefix,
                              Attributes attributes,
                              DeserializationContext context)
           throws SAXException
   {

      if (context.isNil(attributes))
      {
         return;
      }

      //nothing to do

   }

   public SOAPHandler onStartChild(String namespace,
                                   String localName,
                                   String prefix,
                                   Attributes attributes,
                                   DeserializationContext context)
           throws SAXException
   {

      // Get the type
      QName itemType =
              context.getTypeFromAttributes(namespace, localName, attributes);
      // Get the deserializer
      Deserializer dSer = null;
      if (itemType != null)
      {
         dSer = context.getDeserializerForType(itemType);
      }
      if (dSer == null)
      {
         dSer = new DeserializerImpl();
      }

      // When the value is deserialized, inform us.
      // Need to pass the localName as a hint
      dSer.registerValueTarget(new DeserializerTarget(this, localName));

      addChildDeserializer(dSer);

      return (SOAPHandler)dSer;
   }

   public void setChildValue(Object value, Object hint) throws SAXException
   {
      if (hint.equals("className"))
         className = (String)value;
      else if (hint.equals("description"))
         description = (String)value;
      else if (hint.equals("attributes"))
         attributes = (MBeanAttributeInfo[])value;
      else if (hint.equals("constructors"))
         constructors = (MBeanConstructorInfo[])value;
      else if (hint.equals("operations"))
         operations = (MBeanOperationInfo[])value;
      else if (hint.equals("notifications"))
         notifications = (MBeanNotificationInfo[])value;

   }

   public void onEndElement(String s,
                            String s1,
                            DeserializationContext deserializationcontext)
   {
      try
      {
         super.value =
                 new MBeanInfo(className,
                         description,
                         attributes,
                         constructors,
                         operations,
                         notifications);
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
      }
   }

}
