/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:MBeanAttributeInfoDeser.java,v 1.0, 2005-06-24 19:11:43Z, Robert Worsnop$

package org.jboss.net.jmx.adaptor;

import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.encoding.DeserializerTarget;
import org.jboss.axis.message.SOAPHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import javax.management.MBeanAttributeInfo;
import javax.xml.namespace.QName;

/**
 * An <code>MBeanAttributeInfoDeser</code> is be used to deserialize
 * MBeanAttributeInfo using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision:1$
 */
public class MBeanAttributeInfoDeser extends DeserializerImpl
{

   private String name;
   private String type;
   private String description;
   private boolean isReadable;
   private boolean isWritable;
   private boolean isIs;

   public void onStartElement(String namespace,
                              String localName,
                              String prefix,
                              Attributes attributes,
                              DeserializationContext context)
           throws SAXException
   {

      if (context.isNil(attributes))
      {
         return;
      }

      //nothing to do

   }

   public SOAPHandler onStartChild(String namespace,
                                   String localName,
                                   String prefix,
                                   Attributes attributes,
                                   DeserializationContext context)
           throws SAXException
   {

      // Get the type
      QName itemType =
              context.getTypeFromAttributes(namespace, localName, attributes);
      // Get the deserializer
      Deserializer dSer = null;
      if (itemType != null)
      {
         dSer = context.getDeserializerForType(itemType);
      }
      if (dSer == null)
      {
         dSer = new DeserializerImpl();
      }

      // When the value is deserialized, inform us.
      // Need to pass the localName as a hint
      dSer.registerValueTarget(new DeserializerTarget(this, localName));

      addChildDeserializer(dSer);

      return (SOAPHandler)dSer;
   }

   public void setChildValue(Object value, Object hint) throws SAXException
   {
      if (hint.equals("name"))
         name = (String)value;
      else if (hint.equals("type"))
         type = (String)value;
      else if (hint.equals("description"))
         description = (String)value;
      else if (hint.equals("isReadable"))
         isReadable = ((Boolean)value).booleanValue();
      else if (hint.equals("isWritable"))
         isWritable = ((Boolean)value).booleanValue();
      else if (hint.equals("isIs"))
         isIs = ((Boolean)value).booleanValue();

   }

   public void onEndElement(String s,
                            String s1,
                            DeserializationContext deserializationcontext)
   {
      try
      {
         super.value =
                 new MBeanAttributeInfo(name,
                         type,
                         description,
                         isReadable,
                         isWritable,
                         isIs);
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
      }
   }

}
