/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 * Created on Jan 12, 2004
 */
package org.jboss.net.axis.transport.mailto.client;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Transport;
//import org.jboss.net.axis.transport.mail.MailConstants;

/**
 * <dl>
 * <dt><b>Title: </b><dd>Mail Transport</dd>
 * <p>
 * <dt><b>Description: </b><dd>Client side email transport object. This transport needs at least a recipient and an
 * action to work properly.</dd>
 * </dl>
 * @author <a href="mailto:jasone@greenrivercomputing.com">Jason Essington</a>
 * @version $Revision:1$
 */
public class MailTransport extends Transport
{
   public static final String DEFAULT_TRANSPORT_NAME = "mailto";
//   private String toAddress = null;
//   private String fromAddress = null;
//   private String action = null;

//   public MailTransport(String recipient, String action, String sender)
//   {
//      transportName = DEFAULT_TRANSPORT_NAME;
//      this.toAddress = recipient;
//      this.fromAddress = sender;
//      this.action = action;
//   }

//   public MailTransport(String recipient, String action)
//   {
//      transportName = DEFAULT_TRANSPORT_NAME;
//      this.toAddress = recipient;
//      this.action = action;
//   }

   public MailTransport()
   {
      transportName = DEFAULT_TRANSPORT_NAME;
   }

   /* (non-Javadoc)
    * @see org.apache.axis.client.Transport#processReturnedMessageContext(org.apache.axis.MessageContext)
    */
   public void processReturnedMessageContext(MessageContext context)
   {
      // maybe we should do something interesting here.
   }

   /**
    * 
    */
   public void setUrl(String url)
   {
      try
      {
         URL mailto = new URL(url);
         this.transportName = mailto.getProtocol();
//         this.toAddress = mailto.getPath();
         this.url = mailto.toExternalForm();
      }
      catch(MalformedURLException e)
      {
         // maybe we should complain or something
         this.url = url;
      }
   }
   
   public void setupMessageContextImpl(MessageContext msgCtx, Call call, AxisEngine engine) throws AxisFault
   {
      super.setupMessageContextImpl(msgCtx, call, engine);

      // bah! this stuff is now handled by ws-fx/addressing
//      if (toAddress != null)
//         msgCtx.setProperty(MailConstants.MC_IMMEDIATE_DESTINATION, toAddress);
//
//      if (fromAddress != null)
//         msgCtx.setProperty(MailConstants.MC_IMMEDIATE_SENDER, fromAddress);

//      if (action != null)
//      {
//         msgCtx.setUseSOAPAction(true);
//         msgCtx.setSOAPActionURI(this.action);
//      }
      
      // if our service has not been set, we will need to set it based upon
      // the defined SOAPAction otherwise our service handlers will not be run
      if (msgCtx.getService() == null)
      {
         msgCtx.setTargetService(msgCtx.getSOAPActionURI());
      }

   }

//   public void setRecipient(String recipient)
//   {
//      this.toAddress = recipient;
//   }
//
//   public String getRecipient()
//   {
//      return this.toAddress;
//   }
//
//   public void setSender(String sender)
//   {
//      this.fromAddress = sender;
//   }
//
//   public String getSender()
//   {
//      return this.fromAddress;
//   }
//
//   public void setAction(String action)
//   {
//      this.action = action;
//   }
//
//   public String getAction()
//   {
//      return this.action;
//   }

}