/* JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.net.axis.server;

import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;

import org.jboss.logging.Logger;

/** A pojo service which can be used to populate the JAF MailcapCommandMap
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class JAFConfigService
{
   private static Logger log = Logger.getLogger(JAFConfigService.class);
   private String[] mailcaps = {
      "text/xml;;x-java-content-handler=org.jboss.net.axis.jaf.XMLDataContentHandler",
      "application/xml;;x-java-content-handler=org.jboss.net.axis.jaf.XMLDataContentHandler"      
   };

   public String[] getMailcaps()
   {
      return mailcaps;
   }
   public void setMailcaps(String[] mailcaps)
   {
      this.mailcaps = mailcaps;
   }

   public void start() throws Exception
   {
      CommandMap commandMap = CommandMap.getDefaultCommandMap();
      if( commandMap instanceof MailcapCommandMap )
      {
         MailcapCommandMap mailMap = (MailcapCommandMap) commandMap;
         for(int n = 0; n < mailcaps.length; n ++)
         {
            String mailcap = mailcaps[n];
            mailMap.addMailcap(mailcap);
            log.debug("Added mailcap: "+mailcap);
         }
      }
      else
      {
         throw new Exception("Cannot handle non-MailcapCommandMap, map="
            +commandMap);
      }
   }
}
