/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.jboss.axis.types;

/**
 * Custom class for supporting XSD schema
 *
 * @author Davanum Srinivas <dims@yahoo.com>
 */
public class Schema
{
   private org.jboss.axis.message.SOAPElementAxisImpl[] _any;
   private org.jboss.axis.types.URI targetNamespace;  // attribute
   private org.jboss.axis.types.NormalizedString version;  // attribute
   private org.jboss.axis.types.Id id;  // attribute

   public Schema()
   {
   }

   public org.jboss.axis.message.SOAPElementAxisImpl[] get_any()
   {
      return _any;
   }

   public void set_any(org.jboss.axis.message.SOAPElementAxisImpl[] _any)
   {
      this._any = _any;
   }

   public org.jboss.axis.types.URI getTargetNamespace()
   {
      return targetNamespace;
   }

   public void setTargetNamespace(org.jboss.axis.types.URI targetNamespace)
   {
      this.targetNamespace = targetNamespace;
   }

   public org.jboss.axis.types.NormalizedString getVersion()
   {
      return version;
   }

   public void setVersion(org.jboss.axis.types.NormalizedString version)
   {
      this.version = version;
   }

   public org.jboss.axis.types.Id getId()
   {
      return id;
   }

   public void setId(org.jboss.axis.types.Id id)
   {
      this.id = id;
   }

   private java.lang.Object __equalsCalc = null;

   public synchronized boolean equals(java.lang.Object obj)
   {
      if (!(obj instanceof Schema)) return false;
      Schema other = (Schema)obj;
      if (obj == null) return false;
      if (this == obj) return true;
      if (__equalsCalc != null)
      {
         return (__equalsCalc == obj);
      }
      __equalsCalc = obj;
      boolean _equals;
      _equals = true &&
              ((_any == null && other.get_any() == null) ||
              (_any != null &&
              java.util.Arrays.equals(_any, other.get_any()))) &&
              ((targetNamespace == null && other.getTargetNamespace() == null) ||
              (targetNamespace != null &&
              targetNamespace.equals(other.getTargetNamespace()))) &&
              ((version == null && other.getVersion() == null) ||
              (version != null &&
              version.equals(other.getVersion()))) &&
              ((id == null && other.getId() == null) ||
              (id != null &&
              id.equals(other.getId())));
      __equalsCalc = null;
      return _equals;
   }

   private boolean __hashCodeCalc = false;

   public synchronized int hashCode()
   {
      if (__hashCodeCalc)
      {
         return 0;
      }
      __hashCodeCalc = true;
      int _hashCode = 1;
      if (get_any() != null)
      {
         for (int i = 0;
              i < java.lang.reflect.Array.getLength(get_any());
              i++)
         {
            java.lang.Object obj = java.lang.reflect.Array.get(get_any(), i);
            if (obj != null &&
                    !obj.getClass().isArray())
            {
               _hashCode += obj.hashCode();
            }
         }
      }
      if (getTargetNamespace() != null)
      {
         _hashCode += getTargetNamespace().hashCode();
      }
      if (getVersion() != null)
      {
         _hashCode += getVersion().hashCode();
      }
      if (getId() != null)
      {
         _hashCode += getId().hashCode();
      }
      __hashCodeCalc = false;
      return _hashCode;
   }

   // Type metadata
   private static org.jboss.axis.description.TypeDesc typeDesc =
           new org.jboss.axis.description.TypeDesc(Schema.class);

   static
   {
      org.jboss.axis.description.FieldDesc field = new org.jboss.axis.description.AttributeDesc();
      field.setFieldName("targetNamespace");
      field.setXmlName(new javax.xml.namespace.QName("", "targetNamespace"));
      field.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
      typeDesc.addFieldDesc(field);
      field = new org.jboss.axis.description.AttributeDesc();
      field.setFieldName("version");
      field.setXmlName(new javax.xml.namespace.QName("", "version"));
      field.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "normalizedString"));
      typeDesc.addFieldDesc(field);
      field = new org.jboss.axis.description.AttributeDesc();
      field.setFieldName("id");
      field.setXmlName(new javax.xml.namespace.QName("", "id"));
      field.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "ID"));
      typeDesc.addFieldDesc(field);
   }

   /**
    * Return type metadata object
    */
   public static org.jboss.axis.description.TypeDesc getTypeDesc()
   {
      return typeDesc;
   }

   /**
    * Get Custom Serializer
    */
   public static org.jboss.axis.encoding.Serializer getSerializer(java.lang.String mechType,
                                                                  java.lang.Class _javaType,
                                                                  javax.xml.namespace.QName _xmlType)
   {
      return
              new org.jboss.axis.encoding.ser.BeanSerializer(_javaType, _xmlType, typeDesc);
   }

   /**
    * Get Custom Deserializer
    */
   public static org.jboss.axis.encoding.Deserializer getDeserializer(java.lang.String mechType,
                                                                      java.lang.Class _javaType,
                                                                      javax.xml.namespace.QName _xmlType)
   {
      return
              new org.jboss.axis.encoding.ser.BeanDeserializer(_javaType, _xmlType, typeDesc);
   }
}
