/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.xml.registry;

import java.io.ObjectStreamField;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.xml.registry.infomodel.Key;
import javax.xml.namespace.QName;

import org.jboss.util.id.SerialVersion;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class RegistryException
   extends JAXRException
{
   /** @since 4.0.2 */
   static final long serialVersionUID;
   static final int KEY_IDX = 0;
   private static final ObjectStreamField[] serialPersistentFields;
   static
   {
      if (SerialVersion.version == SerialVersion.LEGACY)
      {
         serialVersionUID = 5830899222180533586L;
         serialPersistentFields = new ObjectStreamField[] {
            new ObjectStreamField("key", QName.class),
         };
      }
      else
      {
         serialVersionUID = -2972094643801708304L;
         serialPersistentFields = new ObjectStreamField[] {
            new ObjectStreamField("errorObjectKey", QName.class),
         };
      }
   }

   private Key key;

	public RegistryException()
   {
   }
	public RegistryException(String msg)
   {
      this(msg, null);
   }
	public RegistryException(String msg, Throwable cause)
   {
      super(msg, cause);
   }

	public RegistryException(Throwable cause)
   {
      super(cause);
   }

	public Key getErrorObjectKey() throws JAXRException
   {
      return key;
   }
	public void setErrorObjectKey(Key key) throws JAXRException
   {
      this.key = key;
   }

   // Private -------------------------------------------------------
   private void readObject(ObjectInputStream ois)
      throws ClassNotFoundException, IOException
   {
      ObjectInputStream.GetField fields = ois.readFields();
      String name = serialPersistentFields[KEY_IDX].getName();
      this.key = (Key) fields.get(name, null);
   }

   private void writeObject(ObjectOutputStream oos)
      throws IOException
   {
      ObjectOutputStream.PutField fields =  oos.putFields();
      String name = serialPersistentFields[KEY_IDX].getName();
      fields.put(name, key);
      oos.writeFields();
   }
}
