/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 * 2001/04/08: kjenks: Initial author
 * 2001/06/14: jpedersen: Updated javadoc, removed abstract from methods
 */
package javax.sql;

import java.util.EventListener;

/**
 * <p>A ConnectionEventListener is an object that registers to receive events generated by a PooledConnection.</p>
 *
 * <p>The ConnectionEventListener interface is implemented by a connection pooling component. A connection pooling component
 * will usually be provided by a JDBC driver vendor, or another system software vendor. A ConnectionEventListener is
 * notified by a JDBC driver when an application is finished using its Connection object. This event occurs after the
 * application calls close on its representation of the PooledConnection. A ConnectionEventListener is also notified when
 * a Connection error occurs due to the fact that the PooledConnection is unfit for future use---the server has crashed, for example.
 * The listener is notified, by the JDBC driver, just before the driver throws an SQLException to the application using the
 * PooledConnection.</p>
 */
public interface ConnectionEventListener extends EventListener {

  /**
   * Invoked when the application calls close() on its representation of the connection.
   *
   * @param connectionEvent - an event object describing the source of the event
   */
  public void connectionClosed(ConnectionEvent connectionEvent);

  /**
   * Invoked when a fatal connection error occurs, just before an SQLException is thrown to the application.
   *
   * @param connectionEvent - an event object describing the source of the event
   */
  public void connectionErrorOccurred(ConnectionEvent connectionEvent);
}
