/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.resource.spi.work;

import javax.resource.ResourceException;

/**
 * Thrown when a work is rejected.
 */
public class WorkRejectedException extends WorkException
{
   /**
    * Create an exception.
    */
   public WorkRejectedException()
   {
      super();
   }

   /**
    * Create an exception with a reason.
    *
    * @param reason the reason
    */
   public WorkRejectedException(String reason)
   {
      super(reason);
   }

   /**
    * Create an exception with a reason and an errorCode.
    *
    * @param reason the reason
    * @param errorCode the error code
    */
   public WorkRejectedException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
    * Create an exception with a reason and an error.
    *
    * @param reason the reason
    * @param throwable the error
    */
   public WorkRejectedException(String reason, Throwable throwable)
   {
      super(reason, throwable);
   }

   /**
    * Create an exception with an error.
    *
    * @param throwable the error
    */
   public WorkRejectedException(Throwable throwable)
   {
      super(throwable);
   }
}
