/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.resource.spi.work;

import javax.resource.ResourceException;

/**
 * An error thrown when work is completed.
 */
public class WorkCompletedException extends WorkException
{
   /**
    * Create an exception.
    */
   public WorkCompletedException()
   {
      super();
   }

   /**
    * Create an exception with a reason.
    *
    * @param reason the reason
    */
   public WorkCompletedException(String reason)
   {
      super(reason);
   }

   /**
    * Create an exception with a reason and an errorCode.
    *
    * @param reason the reason
    * @param errorCode the error code
    */
   public WorkCompletedException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
    * Create an exception with a reason and an error.
    *
    * @param reason the reason
    * @param throwable the error
    */
   public WorkCompletedException(String reason, Throwable throwable)
   {
      super(reason, throwable);
   }

   /**
    * Create an exception with an error.
    *
    * @param throwable the error
    */
   public WorkCompletedException(Throwable throwable)
   {
      super(throwable);
   }
}
